/*:
 * @target MZ
 * @plugindesc Backlog Voice Filter v1.0.0 — バックログに載せる音声チャンネルを制御（include/exclude）
 * @author Human
 * @help
 * ■概要
 * HS_BacklogCore_Simple が保存するバックログエントリの voice を
 * チャンネル番号でフィルタします。除外されたチャンネルは
 * バックログに表示されず、クリック再生もされません。
 *
 * ■使い方
 * ・通常は「取り込むチャンネル」にボイス用チャンネル番号だけを指定（例: 1）
 * ・両方空欄なら全チャンネルをそのまま記録します。
 *
 * ■注意
 * ・このプラグインは HS_BacklogCore_Simple.js の後に配置してください。
 *
 * @param includeChannels
 * @text 取り込むチャンネル（優先）
 * @type string
 * @desc 例: 1,2  空欄なら全チャンネル対象。ここで指定したチャンネル以外は記録されません。
 * @default
 *
 * @param excludeChannels
 * @text 除外するチャンネル
 * @type string
 * @desc 例: 2,3  include指定がある場合でも、ここに含まれるチャンネルは除外されます（除外優先）。
 * @default
 */

(() => {
  'use strict';
  const PN = document.currentScript.src.split('/').pop().replace(/\.js$/,'');
  const P  = PluginManager.parameters(PN);

  const parseList = (s) => String(s||'').split(',').map(x=>+x.trim())
                      .filter(n => Number.isFinite(n));
  const INCLUDE = new Set(parseList(P.includeChannels));
  const EXCLUDE = new Set(parseList(P.excludeChannels));

  const shouldKeep = (ch) => {
    let keep = true;
    if (INCLUDE.size > 0) keep = INCLUDE.has(ch);
    if (EXCLUDE.size > 0 && EXCLUDE.has(ch)) keep = false;
    return keep;
  };

  // Game_System.hsPushBacklog を差し替えて voice をフィルタ
  const _hsPush = Game_System.prototype.hsPushBacklog;
  Game_System.prototype.hsPushBacklog = function(entry){
    try{
      if (entry && entry.voice && typeof entry.voice.channel !== 'undefined'){
        const ch = +entry.voice.channel || 0;
        if (!shouldKeep(ch)) {
          // voiceのみ取り除き、それ以外（テキスト等）は記録
          entry = { ...entry, voice: null };
        }
      }
    }catch(e){ console.warn('[HS_BacklogVoiceFilter] error:', e); }
    return _hsPush.call(this, entry);
  };
})();
